using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.IO;
using Borland.Studio.ToolsAPI;
using BeWise.SharpBuilderTools.Utils;

namespace BeWise.SharpBuilderTools.Helpers {

	public abstract class ViewFileModeHelper : IComparer {

		/**************************************************************/
		/*                      Private
		/**************************************************************/

		private ArrayList fItems = new ArrayList();

		/**************************************************************/
		/*                      Public
		/**************************************************************/

		public abstract ListViewItem CreateListViewItem(object aItem);
		public abstract int Compare(object x, object y);
		public abstract void GoTo(object aItem);
		public abstract bool ItemIsVisible(string aFilter, string aProjectFileName, object aItem);
		public abstract void Load();


		/**************************************************************/
		/*                      Properties
		/**************************************************************/

		public ArrayList Items {
			get {
				return fItems;
			}
		}
	}

	public abstract class ViewModuleHelper : ViewFileModeHelper{

		/**************************************************************/
		/*                      Public
		/**************************************************************/

		public override int Compare(object x, object y) {
			IOTAModule _ModuleX = (IOTAModule) (x as ViewFileInfo).Tag;
			IOTAModule _ModuleY = (IOTAModule) (y as ViewFileInfo).Tag;
			return String.Compare(_ModuleX.FileName, _ModuleY.FileName);
		}

		public override void GoTo(object aItem) {
			IOTAModule _Module = (IOTAModule)(aItem as ViewFileInfo).Tag;

			if (_Module != null) {
			  _Module.Show();
			}
		}

	}

	public abstract class ViewModuleInfoHelper : ViewFileModeHelper{

		/**************************************************************/
		/*                      Public
		/**************************************************************/

		public override int Compare(object x, object y) {
			IOTAModuleInfo _ModuleInfoX = (IOTAModuleInfo) (x as ViewFileInfo).Tag;
			IOTAModuleInfo _ModuleInfoY = (IOTAModuleInfo) (y as ViewFileInfo).Tag;;

			return String.Compare(_ModuleInfoX.FileName, _ModuleInfoY.FileName);
		}

		public override void GoTo(object aItem) {
			IOTAModuleInfo _ModuleInfo = (IOTAModuleInfo)(aItem as ViewFileInfo).Tag;
			IOTAModule _Module = _ModuleInfo.OpenModule();

			if (_Module != null) {
				_Module.ShowFileName(_ModuleInfo.FileName);
			}
		}
	}

	public class ViewAllFilesHelper  : ViewModuleInfoHelper {

		/**************************************************************/
		/*                      Public
		/**************************************************************/

		public override ListViewItem CreateListViewItem(object aItem){
			ListViewItem _ListViewItem = new ListViewItem();

			IOTAModuleInfo _ModuleInfo = (IOTAModuleInfo) (aItem as ViewFileInfo).Tag;
			_ListViewItem.Text = Path.GetExtension(_ModuleInfo.FileName);
			_ListViewItem.SubItems.Add(Path.GetFileName(_ModuleInfo.FileName));
			_ListViewItem.Tag = aItem;

			return _ListViewItem;
		}

		public override bool ItemIsVisible(string aFilter, string aProjectFileName, object aItem){
			ViewFileInfo _ViewFileInfo = (ViewFileInfo) aItem;

			if (aProjectFileName == null ||
				(aProjectFileName == "" && _ViewFileInfo.IsInActiveProject) ||
				_ViewFileInfo.ProjectFileName == aProjectFileName) {

				if (aFilter == "") {
					return true;
				}
				else {
					IOTAModuleInfo _ModuleInfo = (IOTAModuleInfo) _ViewFileInfo .Tag;

					return ((Path.GetFileNameWithoutExtension(_ModuleInfo.FileName).ToUpper()).IndexOf(aFilter.ToUpper()) > -1);
				}
			}
			else {
            	return false;
			}
		}

		public override void Load() {
			IOTAModuleServices _ModuleServices = (IOTAModuleServices) BorlandIDE.GetService(typeof(IOTAModuleServices));
			Items.Clear();

			IOTAProjectGroup _ProjectGroup = OTAUtils.GetCurrentProjectGroup();

			if (_ProjectGroup != null) {
				for (int j= 0; j < _ProjectGroup.ProjectCount; j++) {
					IOTAProject _Project = _ProjectGroup[j];

					for (int k = 0; k < _Project.ModuleCount; k++) {
						IOTAModuleInfo _ModuleInfo = _Project.GetModuleInfo(k);

						ViewFileInfo _ViewFileInfo = new ViewFileInfo();
						_ViewFileInfo.ProjectFileName = _Project.FileName;
						_ViewFileInfo.IsInActiveProject = _Project == _ProjectGroup.ActiveProject;
						_ViewFileInfo.Tag = _ModuleInfo;
						Items.Add(_ViewFileInfo);
					}
				}
			}
		}

	}

	public class ViewOpenFilesHelper  : ViewModuleHelper {

		/**************************************************************/
		/*                      Public
		/**************************************************************/

		public override ListViewItem CreateListViewItem(object aItem){
			ListViewItem _ListViewItem = new ListViewItem();

			IOTAModule _Module = (IOTAModule) (aItem as ViewFileInfo).Tag;
			_ListViewItem.Text = Path.GetExtension(_Module.FileName);
			_ListViewItem.SubItems.Add(Path.GetFileName(_Module.FileName));
			_ListViewItem.Tag = aItem;

			return _ListViewItem;
		}

		public override bool ItemIsVisible(string aFilter, string aProjectFileName, object aItem){
			if (aFilter == "") {
				return true;
			}
			else {
				IOTAModule _Module = (IOTAModule) (aItem as ViewFileInfo).Tag;

				return ((Path.GetFileNameWithoutExtension(_Module.FileName).ToUpper()).IndexOf(aFilter.ToUpper()) > -1);
			}
		}

		public override void Load() {
			IOTAModuleServices _ModuleServices = (IOTAModuleServices) BorlandIDE.GetService(typeof(IOTAModuleServices));
			Items.Clear();

			int _Count = _ModuleServices.ModuleCount;
			IOTAProjectGroup _ProjectGroup = OTAUtils.GetCurrentProjectGroup();
			string _ProjectGroupFileName = "";

			if (_ProjectGroup != null) {
				_ProjectGroupFileName = Path.GetFileName(_ProjectGroup.FileName);
			}

			for (int i = 0; i < _Count; i++) {
				IOTAModule _Module = _ModuleServices.GetModule(i);

				if (_Module != null) {
					string _FileName = Path.GetFileName(_Module.FileName);

					if (Path.GetExtension(_FileName).ToUpper() != ".bdsproj".ToUpper() && _FileName != _ProjectGroupFileName) {
						ViewFileInfo _ViewFileInfo = new ViewFileInfo();
						_ViewFileInfo.Tag = _Module;
						Items.Add(_ViewFileInfo);
					}
				}
			}
		}

	}

	public class ViewAssembliesHelper  : ViewModuleInfoHelper {

		/**************************************************************/
		/*                      Public
		/**************************************************************/

		public override ListViewItem CreateListViewItem(object aItem){
			ListViewItem _ListViewItem = new ListViewItem();

			IOTAModuleInfo _ModuleInfo = (IOTAModuleInfo) (aItem as ViewFileInfo).Tag;
			_ListViewItem.Text = Path.GetFileNameWithoutExtension(_ModuleInfo.FileName);
			_ListViewItem.Tag = aItem;

			return _ListViewItem;
		}

		public override bool ItemIsVisible(string aFilter, string aProjectFileName, object aItem){
			ViewFileInfo _ViewFileInfo = (ViewFileInfo) aItem;

			if (aProjectFileName == null ||
				(aProjectFileName == "" && _ViewFileInfo.IsInActiveProject) ||
				_ViewFileInfo.ProjectFileName == aProjectFileName) {

				if (aFilter == "") {
					return true;
				}
				else {
					IOTAModuleInfo _ModuleInfo = (IOTAModuleInfo) (aItem as ViewFileInfo).Tag;

					return ((Path.GetFileNameWithoutExtension(_ModuleInfo.FileName).ToUpper()).IndexOf(aFilter.ToUpper()) > -1);
				}
			} else {
				return false;
			}
		}

		public override void Load() {
			IOTAModuleServices _ModuleServices = (IOTAModuleServices) BorlandIDE.GetService(typeof(IOTAModuleServices));
			Items.Clear();

			IOTAProjectGroup _ProjectGroup = OTAUtils.GetCurrentProjectGroup();

			if (_ProjectGroup != null) {
				for (int j= 0; j < _ProjectGroup.ProjectCount; j++) {
					IOTAProject _Project = _ProjectGroup[j];

					for (int k = 0; k < _Project.ModuleCount; k++) {
						IOTAModuleInfo _ModuleInfo = _Project.GetModuleInfo(k);

						if (Path.GetExtension(_ModuleInfo.FileName).ToUpper() == ".dll".ToUpper()) {
							ViewFileInfo _ViewFileInfo = new ViewFileInfo();
							_ViewFileInfo.ProjectFileName = _Project.FileName;
							_ViewFileInfo.IsInActiveProject = _Project == _ProjectGroup.ActiveProject;
							_ViewFileInfo.Tag = _ModuleInfo;
							Items.Add(_ViewFileInfo);
						}
					}
				}
			}
		}

	}

	public class ViewFormsHelper  : ViewModuleInfoHelper {


		/**************************************************************/
		/*                      Public
		/**************************************************************/

		public override ListViewItem CreateListViewItem(object aItem){
			ListViewItem _ListViewItem = new ListViewItem();

			IOTAModuleInfo _ModuleInfo = (IOTAModuleInfo) (aItem as ViewFileInfo).Tag;
			_ListViewItem.Text = Path.GetFileNameWithoutExtension(_ModuleInfo.FileName);
			_ListViewItem.Tag = aItem;

			return _ListViewItem;
		}

		public override bool ItemIsVisible(string aFilter, string aProjectFileName, object aItem){
			ViewFileInfo _ViewFileInfo = (ViewFileInfo) aItem;

			if (aProjectFileName == null ||
				(aProjectFileName == "" && _ViewFileInfo.IsInActiveProject) ||
				_ViewFileInfo.ProjectFileName == aProjectFileName) {

				if (aFilter == "") {
					return true;
				}
				else {
					IOTAModuleInfo _ModuleInfo = (IOTAModuleInfo) (aItem as ViewFileInfo).Tag;

					return ((Path.GetFileNameWithoutExtension(_ModuleInfo.FileName).ToUpper()).IndexOf(aFilter.ToUpper()) > -1);
				}
			} else {
				return false;
			}
		}

		public override void GoTo(object aItem) {
			IOTAModuleInfo _ModuleInfo = (IOTAModuleInfo) (aItem as ViewFileInfo).Tag;
			IOTAModule _Module = _ModuleInfo.OpenModule();

			_Module.ShowFileName(_ModuleInfo.FileName);
			IOTADotNetModule _DotNetModule = (IOTADotNetModule) _Module.GetService(typeof(IOTADotNetModule));

			if (_DotNetModule != null) {
				_DotNetModule.ShowDesigner();
			}
		}

		public override void Load() {
			IOTAModuleServices _ModuleServices = (IOTAModuleServices) BorlandIDE.GetService(typeof(IOTAModuleServices));
			Items.Clear();

			IOTAProjectGroup _ProjectGroup = OTAUtils.GetCurrentProjectGroup();

			if (_ProjectGroup != null) {
				for (int j= 0; j < _ProjectGroup.ProjectCount; j++) {
					IOTAProject _Project = _ProjectGroup[j];

					for (int k = 0; k < _Project.ModuleCount; k++) {
						IOTAModuleInfo _ModuleInfo = _Project.GetModuleInfo(k);

						if (_ModuleInfo.DesignClassName == "System.Windows.Forms.Form") {
							ViewFileInfo _ViewFileInfo = new ViewFileInfo();
							_ViewFileInfo.ProjectFileName = _Project.FileName;
							_ViewFileInfo.IsInActiveProject = _Project == _ProjectGroup.ActiveProject;
							_ViewFileInfo.Tag = _ModuleInfo;
							Items.Add(_ViewFileInfo);
						}
					}
				}
			}
		}

	}

	public class ViewSourceFilesHelper : ViewModuleInfoHelper {

		/**************************************************************/
		/*                      Public
		/**************************************************************/

		public override ListViewItem CreateListViewItem(object aItem){
			ListViewItem _ListViewItem = new ListViewItem();

			IOTAModuleInfo _ModuleInfo = (IOTAModuleInfo) (aItem as ViewFileInfo).Tag;
			_ListViewItem.Text = Path.GetFileNameWithoutExtension(_ModuleInfo.FileName);
			_ListViewItem.Tag = aItem;

			return _ListViewItem;
		}

		public override bool ItemIsVisible(string aFilter, string aProjectFileName, object aItem){
			ViewFileInfo _ViewFileInfo = (ViewFileInfo) aItem;

			if (aProjectFileName == null ||
				(aProjectFileName == "" && _ViewFileInfo.IsInActiveProject) ||
				_ViewFileInfo.ProjectFileName == aProjectFileName) {

				if (aFilter == "") {
					return true;
				}
				else {
					IOTAModuleInfo _ModuleInfo = (IOTAModuleInfo) (aItem as ViewFileInfo).Tag;

					return ((Path.GetFileNameWithoutExtension(_ModuleInfo.FileName).ToUpper()).IndexOf(aFilter.ToUpper()) > -1);
				}
			} else {
				return false;
			}
		}

		public override void Load() {
			IOTAModuleServices _ModuleServices = (IOTAModuleServices) BorlandIDE.GetService(typeof(IOTAModuleServices));
			Items.Clear();

			IOTAProjectGroup _ProjectGroup = OTAUtils.GetCurrentProjectGroup();

			if (_ProjectGroup != null) {
				for (int j= 0; j < _ProjectGroup.ProjectCount; j++) {
					IOTAProject _Project = _ProjectGroup[j];

					for (int k = 0; k < _Project.ModuleCount; k++) {
						IOTAModuleInfo _ModuleInfo = _Project.GetModuleInfo(k);

						if (Path.GetExtension(_ModuleInfo.FileName).ToUpper() == ".cs".ToUpper()) {
							ViewFileInfo _ViewFileInfo = new ViewFileInfo();
							_ViewFileInfo.ProjectFileName = _Project.FileName;
							_ViewFileInfo.IsInActiveProject = _Project == _ProjectGroup.ActiveProject;
							_ViewFileInfo.Tag = _ModuleInfo;
							Items.Add(_ViewFileInfo);
						}
					}
				}
			}
		}

	}
}
